﻿using System.ComponentModel.DataAnnotations;

namespace FAQ.Models
{
    public class FAQEditViewModel
    {

        /// <summary>
        /// Obtient ou définit la question.
        /// </summary>
        [StringLength(200, MinimumLength = 10)]
        public string Question { get; set; }

        /// <summary>
        /// Obtient ou définit la question.
        /// </summary>
        public DateOnly DateCreation { get; set; }

        /// <summary>
        /// Obtient ou définit la question.
        /// </summary>
        public DateOnly? DateModification { get; set; }

        /// <summary>
        /// Obtient ou définit la Reponse de la question.
        /// </summary>
        public string Reponse { get; set; }

        /// <summary>
        /// Obtient ou définit la Categorie de la question.
        /// </summary>
        public string Categorie { get; set; }
    }
}
